/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsBorders;
import com.pagosoft.plaf.PgsLookAndFeel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PgsTableHeaderUI
extends BasicTableHeaderUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new PgsTableHeaderUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.header.setBorder(null);
        if (this.header.getDefaultRenderer() instanceof UIResource) {
            this.header.setDefaultRenderer(new PgsDefaultTableHeaderCellRenderer());
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n2;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean bl = this.header.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n3 = this.header.columnAtPoint(bl ? point : point2);
        int n4 = this.header.columnAtPoint(bl ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        Rectangle rectangle2 = this.header.getHeaderRect(bl ? n3 : n4);
        if (bl) {
            for (n2 = n3; n2 <= n4; ++n2) {
                int n5;
                TableColumn tableColumn2 = tableColumnModel.getColumn(n2);
                rectangle2.width = n5 = tableColumn2.getWidth();
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n2);
                }
                rectangle2.x += n5;
            }
        } else {
            for (n2 = n4; n2 >= n3; --n2) {
                int n6;
                TableColumn tableColumn3 = tableColumnModel.getColumn(n2);
                rectangle2.width = n6 = tableColumn3.getWidth();
                if (tableColumn3 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n2);
                }
                rectangle2.x += n6;
            }
        }
        if (tableColumn != null) {
            n2 = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle3 = this.header.getHeaderRect(n2);
            graphics.setColor(this.header.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += this.header.getDraggedDistance();
            graphics.setColor(this.header.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            this.paintCell(graphics, rectangle3, n2);
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int n2) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n2);
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            if (tableColumnModel.getColumn(i2) != tableColumn) continue;
            return i2;
        }
        return -1;
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n2) {
        Component component = this.getHeaderRenderer(n2);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private static class PgsDefaultTableHeaderCellRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        public PgsDefaultTableHeaderCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
            if (n3 == jTable.getColumnCount()) {
                this.setBorder(new PgsBorders.Generic(new Insets(0, 0, 1, 0), PgsLookAndFeel.getControlDarkShadow()));
            } else {
                this.setBorder(new PgsBorders.Generic(new Insets(0, 0, 1, 1), PgsLookAndFeel.getControlDarkShadow()));
            }
            this.setBackground(PgsLookAndFeel.getControl());
            return this;
        }
    }
}

